﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace AHOBPR_Job_Runner.DasXml
{
    public class DasResponseValues
    {
        public String BinaryLocationUri { get; set; }
        public String ObjectId { get; set; }
        public String ConversationId { get; set; }

        public DasResponseValues() { }

        public DasResponseValues(String jsonFromDas)
        {
            //Get the Binary Location URI:
            BinaryLocationUri = PullTextBetweenQuotes("\"nc:BinaryLocationURI\":\"", jsonFromDas);

            //Get the Object ID:
            ObjectId = PullTextBetweenQuotes("\"_id\":\"", jsonFromDas);

            //Get the Conversation ID:
            ConversationId = PullTextBetweenQuotes("\"X-ConversationID\":\"", jsonFromDas);
        }

        public String Json
        {
            get
            {
                return "{\"BinaryLocationUri\": \"" + BinaryLocationUri + "\", \"ObjectID\": \"" + ObjectId + "\", \"ConversationID\": \"" + ConversationId + "\"}";
            }
            set
            {
                int startIndex = value.IndexOf(':') + 3;
                int stopIndex = value.IndexOf('\"', startIndex);
                BinaryLocationUri = value.Substring(startIndex, stopIndex - startIndex);

                startIndex = value.IndexOf(':', stopIndex) + 3;
                stopIndex = value.IndexOf('\"', startIndex);
                ObjectId = value.Substring(startIndex, stopIndex - startIndex);

                startIndex = value.IndexOf(':', stopIndex) + 3;
                stopIndex = value.IndexOf('\"', startIndex);
                ConversationId = value.Substring(startIndex, stopIndex - startIndex);
            }
        }

        private String PullTextBetweenQuotes(String textJustBefore, String entireString)
        {
            int startIndex = -1;
            startIndex = entireString.IndexOf(textJustBefore);
            if (0 < startIndex)
            {
                startIndex += textJustBefore.Length;
                int stopIndex = entireString.IndexOf("\"", startIndex);
                if (startIndex < stopIndex)
                {
                    String id = entireString.Substring(startIndex, stopIndex - startIndex);
                    return id;
                }
            }
            return null;
        }
    }
}